string GetDescription()
{
	return "Big classical structure that follows the pattern: A(a-b-a) + B(a-b-c) + A(a-b-a)\n";
}

void GenerateStructure(Song@ song)
{
	song.SetUniqueParts(5);
	
	int m1 = RndInt(3,4);
	int m2 = RndInt(3,4);
	
	song.GetUniquePart(0).SetMetrum(m1);	// a of A and C
	song.GetUniquePart(1).SetMetrum(m1);	// b of A and C
	
	song.GetUniquePart(2).SetMetrum(m2);	// a of B
	song.GetUniquePart(3).SetMetrum(m2);	// b of B
	song.GetUniquePart(4).SetMetrum(m2);	// c of B
	
	song.SetParts(9);	

	int t1 = RndInt(0, 11);
	int t2 = t1;
	
	if (RndInt(0,1) == 0) t2 = (t1 + 5)%12;
	else t2 = (t1 + 9)%12;
	
	string s1 = GetRandomScale();
	string s2 = GetRandomScale();
	
	double te1 = 1.0;
	double te2 = 1.0 + RndFloat(-0.25, 0.5);
	if (RndInt(0,1) == 0) te2 = 1.0f;
			
	song.GetPart(0).SetUniquePart(0);
	song.GetPart(1).SetUniquePart(1);
	song.GetPart(2).SetUniquePart(0);
	song.GetPart(3).SetUniquePart(2);
	song.GetPart(4).SetUniquePart(3);
	song.GetPart(5).SetUniquePart(4);
	song.GetPart(6).SetUniquePart(0);
	song.GetPart(7).SetUniquePart(1);
	song.GetPart(8).SetUniquePart(0);
	
	song.GetPart(0).SetTempoMod(te1);
	song.GetPart(1).SetTempoMod(te1);
	song.GetPart(2).SetTempoMod(te1);
	song.GetPart(3).SetTempoMod(te2);
	song.GetPart(4).SetTempoMod(te2);
	song.GetPart(5).SetTempoMod(te2);
	song.GetPart(6).SetTempoMod(te1);
	song.GetPart(7).SetTempoMod(te1);
	song.GetPart(8).SetTempoMod(te1);
	
	song.GetPart(0).SetScale(s1);
	song.GetPart(1).SetScale(s1);
	song.GetPart(2).SetScale(s1);
	song.GetPart(3).SetScale(s2);
	song.GetPart(4).SetScale(s2);
	song.GetPart(5).SetScale(s2);
	song.GetPart(6).SetScale(s1);
	song.GetPart(7).SetScale(s1);
	song.GetPart(8).SetScale(s1);
	
	song.GetPart(0).SetTranspose(t1);
	song.GetPart(1).SetTranspose(t1);
	song.GetPart(2).SetTranspose(t1);
	song.GetPart(3).SetTranspose(t2);
	song.GetPart(4).SetTranspose(t2);
	song.GetPart(5).SetTranspose(t2);
	song.GetPart(6).SetTranspose(t1);
	song.GetPart(7).SetTranspose(t1);
	song.GetPart(8).SetTranspose(t1);
	
	int a_hint = RndInt(1,2);
	int b_hint = 3;
	
	if (RndInt(0,1) == 0)
	{
		b_hint = RndInt(1,2);
		a_hint = 3;
	}
	
	song.GetPart(0).SetArrHint(a_hint);
	song.GetPart(1).SetArrHint(b_hint);
	song.GetPart(2).SetArrHint(a_hint);
	song.GetPart(3).SetArrHint(RndInt(1,3));
	song.GetPart(4).SetArrHint(RndInt(1,3));
	song.GetPart(5).SetArrHint(RndInt(1,3));
	song.GetPart(6).SetArrHint(a_hint);
	song.GetPart(7).SetArrHint(b_hint);
	song.GetPart(8).SetArrHint(a_hint);
}